/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import teamdraco.unnamedanimalmod.common.entity.util.ai.CapybaraAnimalAttractionGoal;
import teamdraco.unnamedanimalmod.init.UAMEntities;
import teamdraco.unnamedanimalmod.init.UAMItems;
import teamdraco.unnamedanimalmod.init.UAMSounds;

public class CapybaraEntity
extends TameableEntity
implements INamedContainerProvider {
    private static final LazyValue<Set<IItemProvider>> TEMPT_ITEMS = new LazyValue(() -> {
        Stream<IItemProvider> stream = Stream.of(Blocks.field_150440_ba, Items.field_151034_e, Items.field_222065_kN, Items.field_151127_ba, (IItemProvider)UAMItems.MANGROVE_FRUIT.get());
        return stream.map(IItemProvider::func_199767_j).collect(Collectors.toSet());
    });
    private static final DataParameter<Integer> CHESTS = EntityDataManager.func_187226_a(CapybaraEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public IInventory inventory;

    public CapybaraEntity(EntityType<? extends CapybaraEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])((Set)TEMPT_ITEMS.func_179281_c()).toArray(new IItemProvider[0])), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new CapybaraAnimalAttractionGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHESTS, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected float func_189749_co() {
        return 0.65f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_150440_ba.func_199767_j();
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UAMSounds.CAPYBARA_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)UAMSounds.CAPYBARA_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UAMSounds.CAPYBARA_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        Entity entity = p_70097_1_.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            p_70097_2_ = (p_70097_2_ + 1.0f) / 2.0f;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (stack.func_77973_b() == Blocks.field_150486_ae.func_199767_j()) {
                if (this.inventory == null || this.inventory.func_70302_i_() < 27) {
                    this.inventory = new Inventory(27);
                    this.field_70180_af.func_187227_b(CHESTS, (Object)1);
                    if (player.field_71075_bZ.field_75098_d) return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                    stack.func_190918_g(1);
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
                if (this.inventory.func_70302_i_() < 54) {
                    Inventory inv = new Inventory(54);
                    int i = 0;
                    while (true) {
                        if (i >= 27) {
                            this.inventory = inv;
                            this.field_70180_af.func_187227_b(CHESTS, (Object)2);
                            if (player.field_71075_bZ.field_75098_d) return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                            stack.func_190918_g(1);
                            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                        }
                        inv.func_70299_a(i, this.inventory.func_70301_a(i));
                        ++i;
                    }
                }
            }
            if (stack.func_77973_b() != Items.field_151055_y) {
                player.func_213829_a((INamedContainerProvider)this);
                return ActionResultType.SUCCESS;
            }
            this.func_233687_w_(!this.func_233685_eM_());
            return super.func_230254_b_(player, hand);
        }
        if (((Set)TEMPT_ITEMS.func_179281_c()).contains(stack.func_77973_b()) && !this.func_70909_n()) {
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!(this.func_184207_aI() || player.func_226563_dT_() || this.func_70631_g_() || this.func_233684_eK_())) {
            boolean flag = this.func_70877_b(player.func_184586_b(hand));
            if (flag) return super.func_230254_b_(player, hand);
            if (this.func_184207_aI()) return super.func_230254_b_(player, hand);
            if (player.func_226563_dT_()) return super.func_230254_b_(player, hand);
            if (this.field_70170_p.field_72995_K) return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            player.func_184220_m((Entity)this);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.func_184188_bt().isEmpty()) return super.func_230254_b_(player, hand);
        this.func_184226_ay();
        return super.func_230254_b_(player, hand);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public CapybaraEntity getBreedOffspring(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (CapybaraEntity)((EntityType)UAMEntities.CAPYBARA.get()).func_200721_a((World)p_241840_1_);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.5f : 0.9f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.CAPYBARA_SPAWN_EGG.get());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.floatStrider();
        this.func_145775_I();
        if (this.func_184188_bt().isEmpty()) {
            for (Entity e : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(0.5))) {
                if (!(e instanceof MobEntity) || !(e.func_213311_cf() <= 0.75f) || !(e.func_213302_cg() <= 0.75f) || this.func_70631_g_() || ((MobEntity)e).func_70668_bt() == CreatureAttribute.field_203100_e || this.func_70090_H()) continue;
                e.func_184220_m((Entity)this);
            }
        } else if (!this.func_184188_bt().isEmpty() && this.func_70090_H()) {
            this.func_184226_ay();
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new WaterPathNavigator(this, worldIn);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (spawnData == null) {
            spawnData = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnData, dataTag);
    }

    private void floatStrider() {
        if (this.func_70090_H()) {
            ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.inventory != null) {
            ListNBT inv = new ListNBT();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                inv.add((Object)this.inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("Inventory", (INBT)inv);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Inventory")) {
            ListNBT inv = compound.func_150295_c("Inventory", 10);
            this.inventory = new Inventory(inv.size());
            for (int i = 0; i < inv.size(); ++i) {
                this.inventory.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)inv.func_150305_b(i)));
            }
            this.field_70180_af.func_187227_b(CHESTS, (Object)(inv.size() > 27 ? 2 : 1));
        }
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        if (this.inventory == null) {
            return null;
        }
        return this.inventory.func_70302_i_() < 54 ? ChestContainer.func_216992_a((int)p_createMenu_1_, (PlayerInventory)p_createMenu_2_, (IInventory)this.inventory) : ChestContainer.func_216984_b((int)p_createMenu_1_, (PlayerInventory)p_createMenu_2_, (IInventory)this.inventory);
    }

    public int getChestCount() {
        return (Integer)this.field_70180_af.func_187225_a(CHESTS);
    }

    static class WaterPathNavigator
    extends GroundPathNavigator {
        WaterPathNavigator(CapybaraEntity p_i231565_1_, World p_i231565_2_) {
            super((MobEntity)p_i231565_1_, p_i231565_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        protected boolean func_230287_a_(PathNodeType p_230287_1_) {
            return p_230287_1_ == PathNodeType.WATER || super.func_230287_a_(p_230287_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            return this.field_75513_b.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) || super.func_188555_b(pos);
        }
    }
}

